using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class uc_SpeciesFractionAdvancedD : ucBase
    {
        public uc_SpeciesFractionAdvancedD()
        {
            InitializeComponent();

            #region Language added by Yangwenwei
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }

        private void uc_SpeciesFractionAdvancedD_Load(object sender, EventArgs e)
        {
            cboPM25InterpolationDaily.Items.Add("Equal Weighting of Monitors");
            cboPM25InterpolationDaily.Items.Add("Inverse Distance Weights");
            cboPM25InterpolationDaily.Items.Add("Inverse Distance Squared Weights");

            cboSO4InterpolationDaily.Items.Add("Equal Weighting of Monitors");
            cboSO4InterpolationDaily.Items.Add("Inverse Distance Weights");
            cboSO4InterpolationDaily.Items.Add("Inverse Distance Squared Weights");

            cboNO3InterpolationDaily.Items.Add("Equal Weighting of Monitors");
            cboNO3InterpolationDaily.Items.Add("Inverse Distance Weights");
            cboNO3InterpolationDaily.Items.Add("Inverse Distance Squared Weights");

            cboECInterpolationDaily.Items.Add("Equal Weighting of Monitors");
            cboECInterpolationDaily.Items.Add("Inverse Distance Weights");
            cboECInterpolationDaily.Items.Add("Inverse Distance Squared Weights");

            cboSaltInterpolationDaily.Items.Add("Equal Weighting of Monitors");
            cboSaltInterpolationDaily.Items.Add("Inverse Distance Weights");
            cboSaltInterpolationDaily.Items.Add("Inverse Distance Squared Weights");

            cboCrastalInterpolationDaily.Items.Add("Equal Weighting of Monitors");
            cboCrastalInterpolationDaily.Items.Add("Inverse Distance Weights");
            cboCrastalInterpolationDaily.Items.Add("Inverse Distance Squared Weights");

            cboDONInterpolationDaily.Items.Add("Equal Weighting of Monitors");
            cboDONInterpolationDaily.Items.Add("Inverse Distance Weights");
            cboDONInterpolationDaily.Items.Add("Inverse Distance Squared Weights");

            cboOCInterpolationDaily.Items.Add("Equal Weighting of Monitors");
            cboOCInterpolationDaily.Items.Add("Inverse Distance Weights");
            cboOCInterpolationDaily.Items.Add("Inverse Distance Squared Weights");

            cboNH4InterpolationDaily.Items.Add("Equal Weighting of Monitors");
            cboNH4InterpolationDaily.Items.Add("Inverse Distance Weights");
            cboNH4InterpolationDaily.Items.Add("Inverse Distance Squared Weights");
        }

        private void rbtnDONValueDaily_CheckedChanged(object sender, EventArgs e)
        {
            cboDONInterpolationDaily.Enabled = true;
            nudownDONDistanceDaily.Enabled = true;
            cboNH4InterpolationDaily.Enabled = false;
            nudownNH4DistanceDaily.Enabled = false;
            nudownNH4PercDaily.Enabled = false;
        }

        private void rbtnMeasuredAmmoniumDaily_CheckedChanged(object sender, EventArgs e)
        {
            cboDONInterpolationDaily.Enabled = false;
            nudownDONDistanceDaily.Enabled = false;
            cboNH4InterpolationDaily.Enabled = true;
            nudownNH4DistanceDaily.Enabled = true;
            nudownNH4PercDaily.Enabled = true;
        }

        private void lblUsingMonitorData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_2_5_species_fraction_advance.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblInterpolationOptions_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_2_5_species_fraction_advance.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblMiscellOptions_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_2_5_species_fraction_advance.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

    }
}
